clear *
set mem 100m
use "gallup_public_trust.dta", clear

* Keep only variables that are in the sample for twenty surveys or more (This was actually how data were collected)
order church-hmos tv, alphabetic

global institutions ""
foreach v of varlist banks-tv  {
	qui tab survey if `v'<.
	if r(r)<20 {
		di "Dropping `v'"
		drop `v'
	}
	else {
		global institutions "$institutions `v'"
	}
}

* Clean technical variables
rename date dt
format dt %d
gen str2 st=""
levelsof state, local(states)
qui foreach s of local states {
	local statelabel: value label state
	local st: label `statelabel' `s'
	replace st="`st'" if state==`s'
}
drop state
egen stid=group(st)
gen wt=.
levelsof dt, local(dates)
qui foreach d of local dates {
	summ weight if dt==`d'
	replace wt=weight/r(mean) if dt==`d'
}
drop weight 
rename race race_orig
gen race3=race_orig
replace race3=3 if race_orig>2 & race_orig<.
label define race3 1 "White" 2 "Black" 3 "Other"
label values race3 race3

* Organizing variables
gen year=year(dt)

* Rename and relabel and reorder variables
order survey year dt st wt sex age educ race3 race_orig
label define trust 0 "No opinion" 1 "None" 2 "Very little" 3 "Some" 4 "Quite a lot" 5 "A great deal", replace

foreach v of global institutions {
	recode `v' (5=1) (4=2) (3=3) (2=4) (1=5) 
	label values `v' trust
	gen high_`v'=(`v'>=4) if `v'<.
	tab dt high_`v' [aw=wt], row nofreq /*check against published Gallup data*/
	drop high_`v'
	replace `v'=. if `v'==0	
}


* Label variables fully
la var church "Church or org. religion"
la var military "The military"
la var supcourt "U.S. Supreme Court"
la var banks "Banks"
la var schools "The public schools"
la var newspapers "Newspapers"
la var congress "Congress"
la var tvnews "Television news"
la var labor "Organized labor" 
la var presidency "The presidency"
cap la var police "The police"
cap la var medicine "The medical system"
cap la var justice "Criminal justice system"
la var bigbus "Big business"
cap la var smallbus "Small business"
cap la var hmos "HMO's"


* Merge in state economic data
sort st year
merge m:1 st year using "..\State economic conditions\Unemployment", keep(match master)
drop _merge

la data "Now I am going to read you a list of institutions in American society.  Please tell me how much confidence you, yourself, have in each one..."

save "Trust_gallup", replace

